/**
 * \file pappsomspp/processing/cbor/cborstreamwriter.h
 * \date 08/07/2025
 * \author Olivier Langella
 * \brief PAPPSO CBOR stream reader
 *
 * QCborStreamReader overloaded with convenient functions
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include <QCborStreamReader>
#include <QStringList>
#include <QCborMap>
#include <QCborArray>
#include "pappsomspp/export-import-config.h"

namespace pappso
{
namespace cbor
{
/**
 * @todo write docs
 */
class PMSPP_LIB_DECL CborStreamReader : public QCborStreamReader
{
  public:
  /**
   * Default constructor
   */
  CborStreamReader();
  CborStreamReader(QIODevice *device);

  /**
   * Destructor
   */
  virtual ~CborStreamReader();

  /** @brief decode the current cbor value as a string the point to the next value
   * the current value is decoded as a string, beware that using this function, the cbor stream will
   * point to the next cbor value
   * @return true if OK
   */
  bool decodeString(QString &the_str);

  bool readCborMap(QCborMap &cbor_map);
  bool readCborArray(QCborArray &cbor_array);
  bool readArray(std::vector<std::size_t> &int_list);
  bool readArray(std::vector<qint64> &int_list);
  bool readArray(std::vector<double> &double_list);
  bool readArray(std::vector<int> &positions);
  bool readArray(std::vector<std::uint8_t> &small_int_list);
  bool readArray(QStringList &str_list);
  bool readArray(std::vector<QString> &str_list);
};
} // namespace cbor
} // namespace pappso
