% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-numeric.R
\name{transform_boxcox}
\alias{transform_boxcox}
\alias{boxcox_trans}
\alias{transform_modulus}
\alias{modulus_trans}
\title{Box-Cox & modulus transformations}
\usage{
transform_boxcox(p, offset = 0)

boxcox_trans(p, offset = 0)

transform_modulus(p, offset = 1)

modulus_trans(p, offset = 1)
}
\arguments{
\item{p}{Transformation exponent, \eqn{\lambda}.}

\item{offset}{Constant offset. 0 for Box-Cox type 1,
otherwise any non-negative constant (Box-Cox type 2). \code{transform_modulus()}
sets the default to 1.}
}
\description{
The Box-Cox transformation is a flexible transformation, often used to
transform data towards normality. The modulus transformation generalises
Box-Cox to also work with negative values.
}
\details{
The Box-Cox power transformation (type 1) requires strictly positive values and
takes the following form for \eqn{\lambda > 0}:
\deqn{y^{(\lambda)} = \frac{y^\lambda - 1}{\lambda}}{y^(\lambda) = (y^\lambda - 1)/\lambda}
When \eqn{\lambda = 0}, the natural log transform is used.

The modulus transformation implements a generalisation of the Box-Cox
transformation that works for data with both positive and negative values.
The equation takes the following forms, when \eqn{\lambda \neq 0} :
\deqn{y^{(\lambda)} = sign(y) * \frac{(|y| + 1)^\lambda - 1}{\lambda}}{
y^(\lambda) = sign(y)*((|y|+1)^\lambda - 1)/\lambda}
and when \eqn{\lambda = 0}: \deqn{y^{(\lambda)} =  sign(y) * \ln(|y| + 1)}{
y^(\lambda) = sign(y) * ln(|y| + 1)}
}
\examples{
plot(transform_boxcox(-1), xlim = c(0, 10))
plot(transform_boxcox(0), xlim = c(0, 10))
plot(transform_boxcox(1), xlim = c(0, 10))
plot(transform_boxcox(2), xlim = c(0, 10))

plot(transform_modulus(-1), xlim = c(-10, 10))
plot(transform_modulus(0), xlim = c(-10, 10))
plot(transform_modulus(1), xlim = c(-10, 10))
plot(transform_modulus(2), xlim = c(-10, 10))
}
\references{
Box, G. E., & Cox, D. R. (1964). An analysis of transformations.
Journal of the Royal Statistical Society. Series B (Methodological), 211-252.
\url{https://www.jstor.org/stable/2984418}

John, J. A., & Draper, N. R. (1980).
An alternative family of transformations. Applied Statistics, 190-197.
\url{https://www.jstor.org/stable/2986305}
}
\seealso{
\code{\link[=transform_yj]{transform_yj()}}
}
