% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_fonts.R
\name{as_font_weight}
\alias{as_font_weight}
\alias{as_font_width}
\title{Convert weight and width to numerics}
\usage{
as_font_weight(weight)

as_font_width(width)
}
\arguments{
\item{weight, width}{character vectors with valid names for weight or width}
}
\value{
An integer vector matching the length of the input
}
\description{
It is often more natural to describe font weight and width with names rather
than numbers (e.g. "bold" or "condensed"), but underneath these names are
matched to numeric values. These two functions are used to retrieve the
numeric counterparts to names
}
\examples{
as_font_weight(
  c("undefined", "thin", "ultralight", "light", "normal", "medium", "semibold",
    "bold", "ultrabold", "heavy")
)

as_font_width(
  c("undefined", "ultracondensed", "extracondensed", "condensed", "semicondensed",
  "normal", "semiexpanded", "expanded", "extraexpanded", "ultraexpanded")
)

}
\keyword{internal}
